<?php
require __DIR__.'/../db.php';
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

if ($_SERVER['REQUEST_METHOD']==='POST'){
  $b = body();
  $stmt = pdo()->prepare('INSERT INTO productions(product_id, qty, staff_id, created_at) VALUES (?,?,?,NOW())');
  $stmt->execute([(int)$b['product_id'], (int)$b['qty'], (int)$b['staff_id']]);
  pdo()->exec('UPDATE bumps SET version=version+1 WHERE id=1');
  json(['ok'=>true]);
}

if (isset($_GET['latest'])){
  // Return the most recent production entry with product & staff names
  $row = pdo()->query("SELECT pr.id, pr.qty, pr.created_at, p.name AS product_name, s.name AS staff_name
                       FROM productions pr
                       JOIN products p ON p.id=pr.product_id
                       JOIN staff s ON s.id=pr.staff_id
                       ORDER BY pr.id DESC LIMIT 1")->fetch();
  json(['latest'=>$row ?: null]);
}


if ($_SERVER['REQUEST_METHOD']==='GET'){
  // Combined summary:
  // - production_qty: SUM from productions created today (or between from/to)
  // - ready_order_qty: SUM of order_items where the parent order was marked READY today (or between from/to)
  //   We key by orders.updated_at (moment 'ready' was set), not created_at.
  $from = $_GET['from'] ?? null;
  $to   = $_GET['to']   ?? null;

  if ($from && $to){
    $sql = "SELECT p.id, p.name,
                   COALESCE(SUM(pr.qty),0) AS production_qty,
                   COALESCE(SUM(CASE WHEN o.status='ready' THEN oi.qty ELSE 0 END),0) AS ready_order_qty
            FROM products p
            LEFT JOIN productions pr
                   ON pr.product_id=p.id AND pr.created_at BETWEEN ? AND ?
            LEFT JOIN order_items oi
                   ON oi.product_id=p.id
            LEFT JOIN orders o
                   ON o.id=oi.order_id AND o.updated_at BETWEEN ? AND ?
            GROUP BY p.id, p.name
            HAVING production_qty>0 OR ready_order_qty>0
            ORDER BY p.name";
    $stmt = pdo()->prepare($sql);
    $stmt->execute([$from,$to,$from,$to]);
    $rows = $stmt->fetchAll();
    foreach ($rows as &$r){ $r['total_qty'] = (int)$r['production_qty'] + (int)$r['ready_order_qty']; }
    json(['summary'=>$rows,'from'=>$from,'to'=>$to]);
  } else {
    $sql = "SELECT p.id, p.name,
                   COALESCE(SUM(pr.qty),0) AS production_qty,
                   COALESCE(SUM(CASE WHEN o.status='ready' THEN oi.qty ELSE 0 END),0) AS ready_order_qty
            FROM products p
            LEFT JOIN productions pr
                   ON pr.product_id=p.id AND DATE(pr.created_at)=CURDATE()
            LEFT JOIN order_items oi
                   ON oi.product_id=p.id
            LEFT JOIN orders o
                   ON o.id=oi.order_id AND o.status='ready' AND DATE(o.updated_at)=CURDATE()
            GROUP BY p.id, p.name
            HAVING production_qty>0 OR ready_order_qty>0
            ORDER BY p.name";
    $rows = pdo()->query($sql)->fetchAll();
    foreach ($rows as &$r){ $r['total_qty'] = (int)$r['production_qty'] + (int)$r['ready_order_qty']; }
    json(['summary'=>$rows,'from'=>date('Y-m-d 00:00:00'),'to'=>date('Y-m-d 23:59:59')]);
  }
}


json(['error'=>'Method not allowed'],405);
