<?php
// db.php — simple PDO wrapper + env loader
function env($key, $default=null){
  static $env;
  if ($env===null){
    $env = [];
    $envPath = __DIR__.'/.env';
    if (file_exists($envPath)){
      foreach (file($envPath, FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES) as $line){
        if (strpos(trim($line),'#')===0) continue;
        if (strpos($line,'=')===false) continue;
        $parts = explode('=', $line, 2);
        $k = trim($parts[0]);
        $v = trim($parts[1]);
        $env[$k] = $v;
      }
    }
  }
  return array_key_exists($key,$env) ? $env[$key] : $default;
}

function pdo(){
  static $pdo;
  if ($pdo) return $pdo;
  $dsn = 'mysql:host='.env('DB_HOST').';dbname='.env('DB_NAME').';charset=utf8mb4';
  $pdo = new PDO($dsn, env('DB_USER'), env('DB_PASS'), [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
  return $pdo;
}

function json($data, $code=200){
  http_response_code($code);
  header('Content-Type: application/json');
  echo json_encode($data);
  exit;
}

function require_method($method){
  if ($_SERVER['REQUEST_METHOD'] !== $method){
    json(['error'=>'Method not allowed'], 405);
  }
}

function body(){
  $raw = file_get_contents('php://input');
  $d = json_decode($raw, true);
  return is_array($d) ? $d : [];
}

function now(){ return date('Y-m-d H:i:s'); }
?>
